/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template;

import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.io.ByteWriter;
import com.ydn.jsrv.tool.template.io.CharWriter;
import com.ydn.jsrv.tool.template.io.FastStringWriter;
import com.ydn.jsrv.tool.template.stat.Scope;
import com.ydn.jsrv.tool.template.stat.ast.Stat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class Template {
    private Env env;
    private Stat ast;

    public Template(Env env, Stat ast) {
        if (env == null || ast == null) {
            throw new IllegalArgumentException("env and ast can not be null");
        }
        this.env = env;
        this.ast = ast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, OutputStream outputStream) {
        try (ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(outputStream);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
    }

    public void render(OutputStream outputStream) {
        this.render(null, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, Writer writer) {
        try (CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(writer);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
        }
    }

    public void render(Writer writer) {
        this.render(null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderToString(Map<?, ?> data) {
        try (FastStringWriter fsw = this.env.engineConfig.writerBuffer.getFastStringWriter();){
            this.render(data, fsw);
            String string = fsw.toString();
            return string;
        }
    }

    public StringBuilder renderToStringBuilder(Map<?, ?> data) {
        FastStringWriter fsw = new FastStringWriter();
        this.render(data, fsw);
        return fsw.toStringBuilder();
    }

    public void render(Map<?, ?> data, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.render(data, fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void render(Map<?, ?> data, String fileName) {
        this.render(data, new File(fileName));
    }

    public boolean isModified() {
        return this.env.isSourceListModified();
    }
}

