/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.Sym;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Arith
extends Expr {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int BIGDECIMAL = 4;
    private Sym op;
    private Expr left;
    private Expr right;

    public Arith(Sym op, Expr left, Expr right, Location location) {
        if (left == null || right == null) {
            throw new ParseException("The target of \"" + op.value() + "\" operator can not be blank", location);
        }
        this.op = op;
        this.left = left;
        this.right = right;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        try {
            return this.doEval(scope);
        }
        catch (TemplateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    private Object doEval(Scope scope) {
        Object leftValue = this.left.eval(scope);
        Object rightValue = this.right.eval(scope);
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number l = (Number)leftValue;
            Number r = (Number)rightValue;
            int maxType = this.getMaxType(l, r);
            switch (this.op) {
                case ADD: {
                    return this.add(maxType, l, r);
                }
                case SUB: {
                    return this.sub(maxType, l, r);
                }
                case MUL: {
                    return this.mul(maxType, l, r);
                }
                case DIV: {
                    return this.div(maxType, l, r);
                }
                case MOD: {
                    return this.mod(maxType, l, r);
                }
            }
            throw new TemplateException("Unsupported operator: " + this.op.value(), this.location);
        }
        if (leftValue instanceof String || rightValue instanceof String) {
            return String.valueOf(leftValue).concat(String.valueOf(rightValue));
        }
        String leftObj = leftValue != null ? leftValue.getClass().getName() : "null";
        String rightObj = rightValue != null ? rightValue.getClass().getName() : "null";
        throw new TemplateException("Unsupported operation type: " + leftObj + " " + this.op.value() + " " + rightObj, this.location);
    }

    private int getMaxType(Number obj1, Number obj2) {
        int t1 = this.getType(obj1);
        if (t1 == 4) {
            return 4;
        }
        int t2 = this.getType(obj2);
        return t1 > t2 ? t1 : t2;
    }

    private BigDecimal[] toBigDecimals(Number left, Number right) {
        BigDecimal[] ret = new BigDecimal[2];
        if (left instanceof BigDecimal) {
            ret[0] = (BigDecimal)left;
            ret[1] = new BigDecimal(right.toString());
        } else {
            ret[0] = new BigDecimal(left.toString());
            ret[1] = (BigDecimal)right;
        }
        return ret;
    }

    private int getType(Number obj) {
        if (obj instanceof Integer) {
            return 0;
        }
        if (obj instanceof Long) {
            return 1;
        }
        if (obj instanceof Float) {
            return 2;
        }
        if (obj instanceof Double) {
            return 3;
        }
        if (obj instanceof BigDecimal) {
            return 4;
        }
        if (obj instanceof Short || obj instanceof Byte) {
            return 0;
        }
        throw new TemplateException("Unsupported data type: " + obj.getClass().getName(), this.location);
    }

    private Number add(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() + right.intValue();
            }
            case 1: {
                return left.longValue() + right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() + right.floatValue());
            }
            case 3: {
                return left.doubleValue() + right.doubleValue();
            }
            case 4: {
                BigDecimal[] bd = this.toBigDecimals(left, right);
                return bd[0].add(bd[1]);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number sub(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() - right.intValue();
            }
            case 1: {
                return left.longValue() - right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() - right.floatValue());
            }
            case 3: {
                return left.doubleValue() - right.doubleValue();
            }
            case 4: {
                BigDecimal[] bd = this.toBigDecimals(left, right);
                return bd[0].subtract(bd[1]);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number mul(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() * right.intValue();
            }
            case 1: {
                return left.longValue() * right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() * right.floatValue());
            }
            case 3: {
                return left.doubleValue() * right.doubleValue();
            }
            case 4: {
                BigDecimal[] bd = this.toBigDecimals(left, right);
                return bd[0].multiply(bd[1]);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number div(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() / right.intValue();
            }
            case 1: {
                return left.longValue() / right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() / right.floatValue());
            }
            case 3: {
                return left.doubleValue() / right.doubleValue();
            }
            case 4: {
                BigDecimal[] bd = this.toBigDecimals(left, right);
                return bd[0].divide(bd[1], RoundingMode.HALF_EVEN);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number mod(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() % right.intValue();
            }
            case 1: {
                return left.longValue() % right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() % right.floatValue());
            }
            case 3: {
                return left.doubleValue() % right.doubleValue();
            }
            case 4: {
                BigDecimal[] bd = this.toBigDecimals(left, right);
                return bd[0].divideAndRemainder(bd[1])[1];
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }
}

