/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import java.util.ArrayList;

public class Array
extends Expr {
    private Expr[] exprList;

    public Array(Expr[] exprList, Location location) {
        if (exprList == null) {
            throw new ParseException("exprList can not be null", location);
        }
        this.exprList = exprList;
    }

    @Override
    public Object eval(Scope scope) {
        ArrayListExt array = new ArrayListExt(this.exprList.length);
        for (Expr expr : this.exprList) {
            array.add(expr.eval(scope));
        }
        return array;
    }

    public static class ArrayListExt
    extends ArrayList<Object> {
        public ArrayListExt(int initialCapacity) {
            super(initialCapacity);
        }

        public Integer getLength() {
            return this.size();
        }
    }
}

