/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.FieldGetter;
import com.ydn.jsrv.tool.template.expr.ast.FieldKeyBuilder;
import com.ydn.jsrv.tool.template.expr.ast.FieldKit;
import com.ydn.jsrv.tool.template.expr.ast.Id;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import com.ydn.jsrv.util.HashUtil;
import com.ydn.jsrv.util.StrUtil;

public class Field
extends Expr {
    private Expr expr;
    private String fieldName;
    private String getterName;
    private long getterNameHash;

    public Field(Expr expr, String fieldName, Location location) {
        if (expr == null) {
            throw new ParseException("The object for field access can not be null", location);
        }
        this.expr = expr;
        this.fieldName = fieldName;
        this.getterName = "get" + StrUtil.firstCharToUpperCase(fieldName);
        this.getterNameHash = HashUtil.fnv1a64(this.getterName);
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object target = this.expr.eval(scope);
        if (target == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            if (this.expr instanceof Id) {
                String id = ((Id)this.expr).getId();
                throw new TemplateException("\"" + id + "\" can not be null for accessed by \"" + id + "." + this.fieldName + "\"", this.location);
            }
            throw new TemplateException("Can not accessed by \"" + this.fieldName + "\" field from null target", this.location);
        }
        try {
            Class<?> targetClass = target.getClass();
            Object key = FieldKeyBuilder.instance.getFieldKey(targetClass, this.getterNameHash);
            FieldGetter fieldGetter = FieldKit.getFieldGetter(key, targetClass, this.fieldName);
            if (fieldGetter.notNull()) {
                return fieldGetter.get(target, this.fieldName);
            }
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
        if (scope.getCtrl().isNullSafe()) {
            return null;
        }
        if (this.expr instanceof Id) {
            String id = ((Id)this.expr).getId();
            throw new TemplateException("public field not found: \"" + id + "." + this.fieldName + "\" and public getter method not found: \"" + id + "." + this.getterName + "()\"", this.location);
        }
        throw new TemplateException("public field not found: \"" + this.fieldName + "\" and public getter method not found: \"" + this.getterName + "()\"", this.location);
    }
}

