/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.stat.Ctrl;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;

public class NullSafe
extends Expr {
    private Expr left;
    private Expr right;

    public NullSafe(Expr left, Expr right, Location location) {
        if (left == null) {
            throw new ParseException("The expression on the left side of null coalescing and safe access operator \"??\" can not be blank", location);
        }
        this.left = left;
        this.right = right;
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(Scope scope) {
        Ctrl ctrl = scope.getCtrl();
        boolean oldNullSafeValue = ctrl.isNullSafe();
        try {
            ctrl.setNullSafe(true);
            Object ret = this.left.eval(scope);
            if (ret != null) {
                Object object = ret;
                return object;
            }
        }
        finally {
            ctrl.setNullSafe(oldNullSafeValue);
        }
        return this.right != null ? this.right.eval(scope) : null;
    }
}

