/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.ExprList;
import com.ydn.jsrv.tool.template.expr.ast.Method;
import com.ydn.jsrv.tool.template.expr.ast.MethodInfo;
import com.ydn.jsrv.tool.template.expr.ast.MethodKit;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;

public class StaticMethod
extends Expr {
    private Class<?> clazz;
    private String methodName;
    private ExprList exprList;

    public StaticMethod(String className, String methodName, Location location) {
        this.init(className, methodName, ExprList.NULL_EXPR_LIST, location);
    }

    public StaticMethod(String className, String methodName, ExprList exprList, Location location) {
        if (exprList == null || exprList.length() == 0) {
            throw new ParseException("exprList can not be blank", location);
        }
        this.init(className, methodName, exprList, location);
    }

    private void init(String className, String methodName, ExprList exprList, Location location) {
        try {
            this.clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Class not found: " + className, location, e);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), location, e);
        }
        this.methodName = methodName;
        this.exprList = exprList;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object[] argValues = this.exprList.evalExprList(scope);
        try {
            MethodInfo methodInfo = MethodKit.getMethod(this.clazz, this.methodName, argValues);
            if (methodInfo != null) {
                if (methodInfo.isStatic()) {
                    return methodInfo.invoke(null, argValues);
                }
                throw new TemplateException(Method.buildMethodNotFoundSignature("Not public static method: " + this.clazz.getName() + "::", this.methodName, argValues), this.location);
            }
            throw new TemplateException(Method.buildMethodNotFoundSignature("public static method not found: " + this.clazz.getName() + "::", this.methodName, argValues), this.location);
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

