/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.ext.directive;

import com.ydn.jsrv.tool.template.Directive;
import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.ast.Const;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.ExprList;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import com.ydn.jsrv.tool.template.stat.ast.Define;
import java.util.ArrayList;

public class CallDirective
extends Directive {
    protected Expr funcNameExpr;
    protected ExprList paraExpr;
    protected boolean nullSafe = false;

    @Override
    public void setExprList(ExprList exprList) {
        int len = exprList.length();
        if (len == 0) {
            throw new ParseException("\u6a21\u677f\u51fd\u6570\u540d\u4e0d\u80fd\u7f3a\u5931", this.location);
        }
        int index = 0;
        Expr expr = exprList.getExpr(index);
        if (expr instanceof Const && ((Const)expr).isBoolean()) {
            if (len == 1) {
                throw new ParseException("\u6a21\u677f\u51fd\u6570\u540d\u4e0d\u80fd\u7f3a\u5931", this.location);
            }
            this.nullSafe = ((Const)expr).getBoolean();
        }
        int n = ++index;
        this.funcNameExpr = exprList.getExpr(n);
        ArrayList<Expr> list = new ArrayList<Expr>();
        for (int i = ++index; i < len; ++i) {
            list.add(exprList.getExpr(i));
        }
        this.paraExpr = new ExprList(list);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object funcNameValue = this.funcNameExpr.eval(scope);
        if (funcNameValue == null) {
            if (this.nullSafe) {
                return;
            }
            throw new TemplateException("\u6a21\u677f\u51fd\u6570\u540d\u4e3a null", this.location);
        }
        if (!(funcNameValue instanceof String)) {
            throw new TemplateException("\u6a21\u677f\u51fd\u6570\u540d\u5fc5\u987b\u662f\u5b57\u7b26\u4e32", this.location);
        }
        Define func = env.getFunction(funcNameValue.toString());
        if (func == null) {
            if (this.nullSafe) {
                return;
            }
            throw new TemplateException("\u6a21\u677f\u51fd\u6570\u672a\u627e\u5230 : " + funcNameValue, this.location);
        }
        func.call(env, scope, this.paraExpr, writer);
    }
}

