/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.io;

import com.ydn.jsrv.tool.template.io.ByteWriter;
import com.ydn.jsrv.tool.template.io.CharWriter;
import java.io.IOException;

public class IntegerWriter {
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final byte[] minValueBytes = "-2147483648".getBytes();
    private static final char[] minValueChars = "-2147483648".toCharArray();

    public static void write(ByteWriter byteWriter, int i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            byteWriter.out.write(minValueBytes, 0, minValueBytes.length);
            return;
        }
        int size = i < 0 ? IntegerWriter.stringSize(-i) + 1 : IntegerWriter.stringSize(i);
        char[] chars = byteWriter.chars;
        byte[] bytes = byteWriter.bytes;
        IntegerWriter.getChars(i, size, chars);
        for (int j = 0; j < size; ++j) {
            bytes[j] = (byte)chars[j];
        }
        byteWriter.out.write(bytes, 0, size);
    }

    public static void write(CharWriter charWriter, int i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            charWriter.out.write(minValueChars, 0, minValueChars.length);
            return;
        }
        int size = i < 0 ? IntegerWriter.stringSize(-i) + 1 : IntegerWriter.stringSize(i);
        char[] chars = charWriter.chars;
        IntegerWriter.getChars(i, size, chars);
        charWriter.out.write(chars, 0, size);
    }

    static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }
}

