/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.stat.ast;

import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.ExprList;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import com.ydn.jsrv.tool.template.stat.ast.Stat;

public class Output
extends Stat {
    private Expr expr;

    public Output(ExprList exprList, Location location) {
        if (exprList.length() == 0) {
            throw new ParseException("The expression of output directive like #(expression) can not be blank", location);
        }
        this.expr = exprList.getActualExpr();
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        try {
            Object value = this.expr.eval(scope);
            if (value instanceof String) {
                String str = (String)value;
                writer.write(str, 0, str.length());
            } else if (value instanceof Number) {
                Class<?> c = value.getClass();
                if (c == Integer.class) {
                    writer.write((Integer)value);
                } else if (c == Long.class) {
                    writer.write((Long)value);
                } else if (c == Double.class) {
                    writer.write((Double)value);
                } else if (c == Float.class) {
                    writer.write(((Float)value).floatValue());
                } else if (c == Short.class) {
                    writer.write((Short)value);
                } else {
                    writer.write(value.toString());
                }
            } else if (value != null) {
                writer.write(value.toString());
            }
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

