/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.stat.ast;

import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.ExprList;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import com.ydn.jsrv.tool.template.stat.ast.Case;
import com.ydn.jsrv.tool.template.stat.ast.CaseSetter;
import com.ydn.jsrv.tool.template.stat.ast.Default;
import com.ydn.jsrv.tool.template.stat.ast.Stat;

public class Switch
extends Stat
implements CaseSetter {
    private Expr expr;
    private Case nextCase;
    private Default _default;

    public Switch(ExprList exprList, Location location) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #switch directive can not be blank", location);
        }
        this.expr = exprList.getActualExpr();
    }

    @Override
    public void setNextCase(Case nextCase) {
        this.nextCase = nextCase;
    }

    public void setDefault(Default _default, Location location) {
        if (this._default != null) {
            throw new ParseException("The #default case of #switch is already defined", location);
        }
        this._default = _default;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object switchValue = this.expr.eval(scope);
        if (this.nextCase != null && this.nextCase.execIfMatch(switchValue, env, scope, writer)) {
            return;
        }
        if (this._default != null) {
            this._default.exec(env, scope, writer);
        }
    }

    @Override
    public boolean hasEnd() {
        return true;
    }
}

