/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.thread;

import com.ydn.jsrv.tool.thread.ExecutorBuilder;
import com.ydn.jsrv.tool.thread.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

public class AsyncUtil {
    public static final int DEFAULT_THREADPOOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_POOL_SIZE = 1024;
    public static final String DEFAULT_TASK = "task";
    private static final Map<String, ThreadPoolExecutor> EXECUTOR_SERVICE_MAPPINGS = new HashMap<String, ThreadPoolExecutor>();

    public static void submit(Callable c) {
        AsyncUtil.getExecutor(DEFAULT_TASK).submit(c);
    }

    public static void submit(String taskName, Callable c) {
        AsyncUtil.getExecutor(taskName, DEFAULT_THREADPOOL_SIZE).submit(c);
    }

    public void submit(Runnable r) {
        AsyncUtil.getExecutor(DEFAULT_TASK).submit(r);
    }

    public static void submit(String taskName, Runnable r) {
        AsyncUtil.getExecutor(taskName, DEFAULT_THREADPOOL_SIZE).submit(r);
    }

    public static void close() {
        for (ThreadPoolExecutor executor : EXECUTOR_SERVICE_MAPPINGS.values()) {
            executor.shutdown();
        }
    }

    private static ThreadPoolExecutor getExecutor(String name) {
        return AsyncUtil.getExecutor(name, DEFAULT_THREADPOOL_SIZE);
    }

    private static synchronized ThreadPoolExecutor getExecutor(String name, int size) {
        if (EXECUTOR_SERVICE_MAPPINGS.containsKey(name)) {
            return EXECUTOR_SERVICE_MAPPINGS.get(name);
        }
        ThreadPoolExecutor executor = ExecutorBuilder.create().setCorePoolSize(size).setMaxPoolSize(size).setWorkQueue(new LinkedBlockingQueue<Runnable>(1024)).setThreadFactory(ThreadFactoryBuilder.create().setNamePrefix(name).build()).build();
        EXECUTOR_SERVICE_MAPPINGS.put(name, executor);
        return executor;
    }
}

