/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.undertow;

import com.ydn.jsrv.undertow.CompositeResourceManager;
import com.ydn.jsrv.undertow.PathKitExt;
import com.ydn.jsrv.undertow.UndertowConfig;
import com.ydn.jsrv.undertow.UndertowKit;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ResourceManagerBuilder {
    public ResourceManager build(String resourcePath, ClassLoader classLoader) {
        List<String> resourcePathList = this.buildResourcePathList(resourcePath);
        CompositeResourceManager ret = new CompositeResourceManager();
        this.buildFileResourceManager(resourcePathList, classLoader, ret);
        this.buildClassPathResourceManager(resourcePathList, classLoader, ret);
        return ret;
    }

    private List<String> buildResourcePathList(String resourcePath) {
        String[] resourcePathArray;
        ArrayList<String> ret = new ArrayList<String>();
        for (String path : resourcePathArray = resourcePath.split(",")) {
            if (!UndertowConfig.notBlank(path)) continue;
            ret.add(path.trim().replace(" ", ""));
        }
        if (!ret.contains("webapp")) {
            ret.add("webapp");
        }
        return ret;
    }

    private void buildFileResourceManager(List<String> resourcePathList, ClassLoader classLoader, CompositeResourceManager ret) {
        for (String path : resourcePathList) {
            if (!new File(path).isDirectory()) continue;
            ret.add((ResourceManager)this.createFileResourceManager(path));
        }
        if (UndertowKit.isDeployMode()) {
            this.forDeployMode(classLoader, ret);
        }
    }

    private FileResourceManager createFileResourceManager(String path) {
        return new FileResourceManager(new File(path), 1024L, false);
    }

    private void forDeployMode(ClassLoader classLoader, CompositeResourceManager ret) {
        if (ret.isEmpty()) {
            String path = PathKitExt.getLocationPath();
            if (path.endsWith(File.separatorChar + "lib")) {
                path = path.substring(0, path.lastIndexOf(File.separatorChar));
            }
            if (new File(path = new File(path + File.separator + "webapp").getAbsolutePath()).isDirectory()) {
                ret.add((ResourceManager)this.createFileResourceManager(path));
            }
        }
    }

    private void buildClassPathResourceManager(List<String> resourcePathList, ClassLoader classLoader, CompositeResourceManager ret) {
        String prefix = "classpath:";
        for (String path : resourcePathList) {
            if (!path.startsWith(prefix) || !UndertowConfig.notBlank(path = path.substring(prefix.length()))) continue;
            ret.add((ResourceManager)new ClassPathResourceManager(classLoader, path));
        }
    }
}

