/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.undertow.ssl;

import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.undertow.UndertowConfig;

public class SslConfig {
    static final String SSL_ENABLE = "undertow.ssl.enable";
    static final String SSL_PORT = "undertow.ssl.port";
    static final String SSL_PROTOCOL = "undertow.ssl.protocol";
    static final String SSL_KEY_STORE_TYPE = "undertow.ssl.keyStoreType";
    static final String SSL_KEY_STORE = "undertow.ssl.keyStore";
    static final String SSL_KEY_STORE_PASSWORD = "undertow.ssl.keyStorePassword";
    static final String SSL_KEY_ALIAS = "undertow.ssl.keyAlias";
    static final String SSL_KEY_PASSWORD = "undertow.ssl.keyPassword";
    protected boolean enable = GlobalYamlConfiguration.getBoolean("undertow.ssl.enable", this.enable);
    protected int port = GlobalYamlConfiguration.getInt("undertow.ssl.port", this.port);
    protected String protocol = GlobalYamlConfiguration.getString("undertow.ssl.protocol", this.protocol);
    protected String keyStoreType = GlobalYamlConfiguration.getString("undertow.ssl.keyStoreType");
    protected String keyStore = GlobalYamlConfiguration.getString("undertow.ssl.keyStore");
    protected String keyStorePassword = GlobalYamlConfiguration.getString("undertow.ssl.keyStorePassword");
    protected String keyAlias = GlobalYamlConfiguration.getString("undertow.ssl.keyAlias");
    protected String keyPassword = GlobalYamlConfiguration.getString("undertow.ssl.keyPassword");

    public SslConfig() {
        if (this.enable) {
            this.checkConfig();
        }
    }

    protected void checkConfig() {
        if (UndertowConfig.isBlank(this.keyStore)) {
            throw new IllegalStateException("undertow.ssl.keyStore can not be blank");
        }
        if (UndertowConfig.isBlank(this.keyStorePassword)) {
            throw new IllegalStateException("undertow.ssl.keyStorePassword can not be blank");
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }
}

