/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.util;

import com.ydn.jsrv.exception.JsrvException;
import com.ydn.jsrv.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;

public class ClassUtils {
    public static <T> List<Class<T>> findClasses(Class<T> iface, String ... packageNames) {
        URL[] classPaths;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(packageNames));
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (URL classPathUrl : classPaths = ((URLClassLoader)classLoader).getURLs()) {
            File classPath;
            Enumeration<Object> files = null;
            JarFile module = null;
            try {
                classPath = new File(classPathUrl.toURI());
            }
            catch (URISyntaxException e) {
                LogUtil.error("Skipping classPath '" + classPathUrl + "'", e);
                continue;
            }
            if (!classPath.exists()) continue;
            if (classPath.isDirectory()) {
                ArrayList<String> dirListing = new ArrayList<String>();
                ClassUtils.recursivelyListDir(dirListing, classPath, new StringBuffer());
                files = Collections.enumeration(dirListing);
            } else if (classPath.getName().endsWith(".jar")) {
                try {
                    module = new JarFile(classPath);
                    files = module.entries();
                }
                catch (MalformedURLException e) {
                    LogUtil.error("Skipping classPath '" + classPathUrl + "'", e);
                }
                catch (IOException e) {
                    LogUtil.error("Skipping classPath '" + classPathUrl + "'", e);
                }
            }
            while (files != null && files.hasMoreElements()) {
                Class<?> theClass;
                String fileName = files.nextElement().toString();
                if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
                String className = fileName.replaceAll("/", ".").substring(0, fileName.length() - 6);
                if (packages != null && !ClassUtils.classPathValily(packages, className)) continue;
                try {
                    theClass = Class.forName(className, false, classLoader);
                }
                catch (NoClassDefFoundError e) {
                    LogUtil.error("Skipping class '" + className + "'", e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LogUtil.error("Skipping class '" + className + "'", e);
                    continue;
                }
                if (result.contains(theClass) || iface == null || !iface.isAssignableFrom(theClass)) continue;
                result.add(theClass);
            }
            if (module == null) continue;
            try {
                module.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean classPathValily(List<String> packages, String className) {
        String classPackage = ClassUtils.removePackageName(className);
        for (String pack : packages) {
            if (classPackage.indexOf(pack) != 0) continue;
            return true;
        }
        return false;
    }

    public static <T> Class<T> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            new JsrvException("class for name error:" + className, e);
            return null;
        }
    }

    private static String removePackageName(String className) {
        if (!className.contains(".")) {
            return className;
        }
        return className.substring(0, className.lastIndexOf("."));
    }

    private static void recursivelyListDir(List<String> dirListing, File dir, StringBuffer relativePath) {
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                int prevLen = relativePath.length();
                ClassUtils.recursivelyListDir(dirListing, file, relativePath.append(prevLen == 0 ? "" : "/").append(file.getName()));
                relativePath.delete(prevLen, relativePath.length());
            }
        } else {
            dirListing.add(relativePath.toString());
        }
    }
}

