package com.ydn.simplelock;

import com.ydn.simplelock.configuration.ZkLockConfiguration;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;

import java.util.concurrent.TimeUnit;

/**
 * @author Feng Chen
 */
public class ZkLock implements Lock {

    private String name;

    private InterProcessMutex internalLock;

    public ZkLock(CuratorFramework curator, ZkLockConfiguration configuration, String name) {
        this.name = name;
        this.internalLock = new InterProcessMutex(curator, PathUtils.getPath(configuration, name));
    }

    @Override
    public void acquire() throws Exception {
        internalLock.acquire(10, TimeUnit.SECONDS);
    }

    @Override
    public void release() throws Exception {
        internalLock.release();
    }


    //////////////////////////////////////////

    private abstract static class PathUtils {

        private static final String ROOT = "/";
        private static final String SLASH = "/";

        private PathUtils() {

        }

        public static String getPath(ZkLockConfiguration configuration, String dir) {
            return new StringBuilder()
                    .append(ROOT)
                    .append(configuration.getNamespace())
                    .append(SLASH)
                    .append(dir)
                    .toString();
        }
    }

}
