package com.ydn.simplelock.adapter;

import com.ydn.simplelock.Lock;
import com.ydn.simplelock.ZkLock;
import com.ydn.simplelock.configuration.ZkLockConfiguration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

/**
 * @author Feng Chen
 */
public class ZkLockAdapter implements LockAdapter {

    private ZkLockConfiguration configuration;

    private CuratorFramework curator;

    public ZkLockAdapter(ZkLockConfiguration configuration) {
        this.configuration = configuration;

        initCurator();

    }

    @Override
    public Lock getLock(String key) {
        return new ZkLock(curator, configuration, key);
    }

    @Override
    public void close() {
        curator.close();
    }

    // SECTION: INNER HELPER

    private void initCurator() {
        RetryPolicy retryPolicy = new ExponentialBackoffRetry(configuration.getBaseSleepTimeMs(), configuration.getMaxRetries());
        this.curator = CuratorFrameworkFactory.newClient(
                configuration.getZkHosts(),
                configuration.getSessionTimeoutMs(),
                configuration.getConnectionTimeoutMs(),
                retryPolicy
        );

        this.curator.start();
    }
}
