package com.ydn.simplelock.configuration;

/**
 * @author Feng Chen
 */
public class RedisLockConfiguration implements LockConfiguration {

    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 6379;
    private static final int DEFAULT_MAX_ACTIVE = 5;
    private static final int DEFAULT_MIN_IDLE = 3;

    private String host = DEFAULT_HOST;
    private int port = DEFAULT_PORT;


    private int timeout;
    private String password;
    private int database;

    private int maxActive = DEFAULT_MAX_ACTIVE;
    private int minIdle = DEFAULT_MIN_IDLE;


    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxActive() {
        return maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMinIdle() {
        return minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }
}
