/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.simplelock;

import com.ydn.simplelock.Lock;
import com.ydn.simplelock.configuration.ZkLockConfiguration;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;

public class ZkLock
implements Lock {
    private String name;
    private InterProcessMutex internalLock;

    public ZkLock(CuratorFramework curator, ZkLockConfiguration configuration, String name) {
        this.name = name;
        this.internalLock = new InterProcessMutex(curator, PathUtils.getPath(configuration, name));
    }

    @Override
    public void acquire() throws Exception {
        this.internalLock.acquire(10L, TimeUnit.SECONDS);
    }

    @Override
    public void release() throws Exception {
        this.internalLock.release();
    }

    private static abstract class PathUtils {
        private static final String ROOT = "/";
        private static final String SLASH = "/";

        private PathUtils() {
        }

        public static String getPath(ZkLockConfiguration configuration, String dir) {
            return "/" + configuration.getNamespace() + "/" + dir;
        }
    }
}

