/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.simplelock.adapter;

import com.ydn.simplelock.adapter.LockAdapter;
import com.ydn.simplelock.adapter.RedisLockAdapter;
import com.ydn.simplelock.adapter.ZkLockAdapter;
import com.ydn.simplelock.configuration.LockConfiguration;
import com.ydn.simplelock.configuration.RedisLockConfiguration;
import com.ydn.simplelock.configuration.ZkLockConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LockAdapterFactory {
    private static final Map<Class<? extends LockConfiguration>, LockAdapterCreator> CREATOR_MAP = new HashMap<Class<? extends LockConfiguration>, LockAdapterCreator>();

    public static LockAdapter createLockAdapter(LockConfiguration configuration) {
        Class<? extends LockConfiguration> cacheConfigType;
        boolean isCompatibleType;
        Iterator<Class<? extends LockConfiguration>> it = CREATOR_MAP.keySet().iterator();
        do {
            if (it.hasNext()) continue;
            throw new IllegalArgumentException("Unrecognized configuration type: " + configuration.getClass());
        } while (!(isCompatibleType = (cacheConfigType = it.next()).isAssignableFrom(configuration.getClass())));
        return CREATOR_MAP.get(configuration.getClass()).create(configuration);
    }

    static {
        CREATOR_MAP.put(ZkLockConfiguration.class, new ZkLockAdapterCreator());
        CREATOR_MAP.put(RedisLockConfiguration.class, new RedisLockAdapterCreator());
    }

    private static interface LockAdapterCreator<T extends LockConfiguration> {
        public LockAdapter create(T var1);
    }

    private static class RedisLockAdapterCreator
    implements LockAdapterCreator<RedisLockConfiguration> {
        private RedisLockAdapterCreator() {
        }

        @Override
        public LockAdapter create(RedisLockConfiguration configuration) {
            return new RedisLockAdapter(configuration);
        }
    }

    private static class ZkLockAdapterCreator
    implements LockAdapterCreator<ZkLockConfiguration> {
        private ZkLockAdapterCreator() {
        }

        @Override
        public LockAdapter create(ZkLockConfiguration configuration) {
            return new ZkLockAdapter(configuration);
        }
    }
}

