/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.simplelock.adapter;

import com.ydn.simplelock.Lock;
import com.ydn.simplelock.ZkLock;
import com.ydn.simplelock.adapter.LockAdapter;
import com.ydn.simplelock.configuration.ZkLockConfiguration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class ZkLockAdapter
implements LockAdapter {
    private ZkLockConfiguration configuration;
    private CuratorFramework curator;

    public ZkLockAdapter(ZkLockConfiguration configuration) {
        this.configuration = configuration;
        this.initCurator();
    }

    @Override
    public Lock getLock(String key) {
        return new ZkLock(this.curator, this.configuration, key);
    }

    @Override
    public void close() {
        this.curator.close();
    }

    private void initCurator() {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.configuration.getBaseSleepTimeMs(), this.configuration.getMaxRetries());
        this.curator = CuratorFrameworkFactory.newClient((String)this.configuration.getZkHosts(), (int)this.configuration.getSessionTimeoutMs(), (int)this.configuration.getConnectionTimeoutMs(), (RetryPolicy)retryPolicy);
        this.curator.start();
    }
}

