package com.ydn.simplelock;

import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

/**
 * @author Feng Chen
 */
public class RedisLock implements Lock {

    private final RLock rLock;

    private static final Logger logger = LoggerFactory.getLogger(RedisLock.class);

    public RedisLock(RedissonClient client, String key) {
        rLock = client.getLock(key);
    }

    @Override
    public void acquire() throws Exception {
        logger.info("RedisLock {} acquire...", rLock.getName());
        rLock.lock(10, TimeUnit.SECONDS);
    }

    @Override
    public void release() throws Exception {
        if (rLock.isLocked() && rLock.isHeldByCurrentThread()) {
            logger.info("RedisLock {} release...", rLock.getName());
            rLock.unlock();
        }
    }

}
