package com.ydn.simplelock.adapter;

import com.ydn.simplelock.Lock;
import com.ydn.simplelock.RedisLock;
import com.ydn.simplelock.configuration.RedisLockConfiguration;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

/**
 * @author Feng Chen
 */
public class RedisLockAdapter implements LockAdapter {

    private final RedissonClient client;

    private RedisLockConfiguration configuration;

    public RedisLockAdapter(RedisLockConfiguration configuration) {
        this.configuration = configuration;
        client = Redisson.create(options());
    }

    @Override
    public Lock getLock(String key) {
        return new RedisLock(client, namespace(key));
    }

    @Override
    public void close() {
        client.shutdown();
    }

    // SECTION : INNER HELPER

    private Config options() {
        Config config = new Config();
        config.useSingleServer()
                .setAddress(String.format("redis://%s:%d", configuration.getHost(), configuration.getPort()))
                .setPassword(configuration.getPassword())
                .setConnectionPoolSize(configuration.getMaxActive())
                .setConnectionMinimumIdleSize(configuration.getMinIdle())
                .setConnectTimeout(configuration.getTimeout());
        return config;
    }

    private String namespace(String key) {
        return new StringBuilder()
                .append(configuration.getNamespace())
                .append("_")
                .append(key)
                .toString();
    }


}
