package com.ydn.simplelock.configuration;

/**
 * @author Feng Chen
 */
public class RedisLockConfiguration implements LockConfiguration {

    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_NAMESPACE = "simplelock";
    private static final int DEFAULT_PORT = 6379;
    private static final int DEFAULT_MAX_ACTIVE = 5;
    private static final int DEFAULT_MIN_IDLE = 3;

    private String namespace = DEFAULT_NAMESPACE;
    private String host = DEFAULT_HOST;
    private int port = DEFAULT_PORT;

    private String password;
    private int database;

    private int timeout;

    private int maxActive = DEFAULT_MAX_ACTIVE;
    private int minIdle = DEFAULT_MIN_IDLE;

    public RedisLockConfiguration() {
    }

    public RedisLockConfiguration(String namespace, String host, int port) {
        this.namespace = namespace;
        this.host = host;
        this.port = port;
    }

    public RedisLockConfiguration(String namespace, String host, int port, int database) {
        this.namespace = namespace;
        this.host = host;
        this.port = port;
        this.database = database;
    }

    public RedisLockConfiguration(String namespace, String host, int port, String password, int timeout, int maxActive, int minIdle) {
        this.namespace = namespace;
        this.host = host;
        this.port = port;
        this.password = password;
        this.database = database;
        this.timeout = timeout;
        this.maxActive = maxActive;
        this.minIdle = minIdle;
    }

    public RedisLockConfiguration(String namespace, String host, int port, String password) {
        this.namespace = namespace;
        this.host = host;
        this.port = port;
        this.password = password;
    }

    public RedisLockConfiguration(String namespace, String host, int port, String password, int database) {
        this.namespace = namespace;
        this.host = host;
        this.port = port;
        this.password = password;
        this.database = database;
    }

    public RedisLockConfiguration(String namespace, String host, int port, String password, int database, int timeout, int maxActive, int minIdle) {
        this.namespace = namespace;
        this.host = host;
        this.port = port;
        this.password = password;
        this.database = database;
        this.timeout = timeout;
        this.maxActive = maxActive;
        this.minIdle = minIdle;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxActive() {
        return maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMinIdle() {
        return minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }
}
