/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.simplelock;

import com.ydn.simplelock.Lock;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLock
implements Lock {
    private final RLock rLock;
    private static final Logger logger = LoggerFactory.getLogger(RedisLock.class);

    public RedisLock(RedissonClient client, String key) {
        this.rLock = client.getLock(key);
    }

    @Override
    public void acquire() throws Exception {
        logger.info("RedisLock {} acquire...", (Object)this.rLock.getName());
        this.rLock.lock(10L, TimeUnit.SECONDS);
    }

    @Override
    public void release() throws Exception {
        if (this.rLock.isLocked() && this.rLock.isHeldByCurrentThread()) {
            logger.info("RedisLock {} release...", (Object)this.rLock.getName());
            this.rLock.unlock();
        }
    }
}

