/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.simplelock.adapter;

import com.ydn.simplelock.Lock;
import com.ydn.simplelock.RedisLock;
import com.ydn.simplelock.adapter.LockAdapter;
import com.ydn.simplelock.configuration.RedisLockConfiguration;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public class RedisLockAdapter
implements LockAdapter {
    private final RedissonClient client;
    private RedisLockConfiguration configuration;

    public RedisLockAdapter(RedisLockConfiguration configuration) {
        this.configuration = configuration;
        this.client = Redisson.create((Config)this.options());
    }

    @Override
    public Lock getLock(String key) {
        return new RedisLock(this.client, this.namespace(key));
    }

    @Override
    public void close() {
        this.client.shutdown();
    }

    private Config options() {
        Config config = new Config();
        ((SingleServerConfig)config.useSingleServer().setAddress(String.format("redis://%s:%d", this.configuration.getHost(), this.configuration.getPort())).setPassword(this.configuration.getPassword())).setConnectionPoolSize(this.configuration.getMaxActive()).setConnectionMinimumIdleSize(this.configuration.getMinIdle()).setConnectTimeout(this.configuration.getTimeout());
        return config;
    }

    private String namespace(String key) {
        return this.configuration.getNamespace() + "_" + key;
    }
}

